package org.msh.tb.bd.dashboard.detailedrep;

import org.jboss.seam.annotations.Name;
import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;
import org.msh.tb.bd.dashboard.query.GeoDistributionQuery;
import org.msh.tb.bd.dashboard.summaryrep.data.GeoDistributionData;
import org.msh.tb.bd.dashboard.summaryrep.parser.GeoDistributionParser;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.utils.JsonUtils;

import java.util.List;

/**
 * Created by Mauricio on 12/06/2017.
 */
@Name("geoDistributionRep")
public class GeoDistributionRep extends DetailedIndicator<GeoDistributionQuery> {

    private boolean consolidateByLowerLevel;

    private GeoDistributionData geoData;

    @Override
    protected void createIndicators() {
        AdministrativeUnit auSelected = getIndicatorFilters().getTbunitselection().getAuselection().getSelectedUnit();

        // set params to indicator query
        getQuery().setIniDate(getIndicatorFilters().getIniDate());
        getQuery().setEndDate(getIndicatorFilters().getEndDate());
        getQuery().setSelectedAdminUnit(auSelected);
        getQuery().setCaseClassification(getIndicatorFilters().getClassification());
        getQuery().setGender(getIndicatorFilters().getGender());
        getQuery().setConsolidateByLowerLevel(consolidateByLowerLevel);

        List<Object[]> result = getQuery().getDetailedResult();

        // populate indicator table
        for(Object[] r : result){
            AdministrativeUnit adminUnit = (AdministrativeUnit) r[0];
            Long caseQtt = (Long) r[1];

            addValue(getMessage("cases.ongoing.notifs"), adminUnit.getFullDisplayName2(), caseQtt != null ? caseQtt.floatValue() : 0);
        }

        GeoDistributionParser parser = new GeoDistributionParser();
        geoData = parser.parse(result, null);
    }

    public String getGeoMapDataJSON() {
        if (geoData == null) {
            // forces the creation of all data for this report
            getTable();
        }

        geoData.setMaximumCircleSize(consolidateByLowerLevel ? 15000 :
                DashboardIndicatorUtils.getMaximumCircleSize(getIndicatorFilters().getTbunitselection().getAuselection().getSelectedUnit()));

        return JsonUtils.objectToJSONString(geoData,false);
    }

    @Override
    protected GeoDistributionQuery getQueryNewInstance() {
        return new GeoDistributionQuery();
    }

    @Override
    protected void createChartData() {
        // do nothing, this indicator should not display highcharts
    }

    public boolean isConsolidateByLowerLevel() {
        return consolidateByLowerLevel;
    }

    public void setConsolidateByLowerLevel(boolean consolidateByLowerLevel) {
        this.consolidateByLowerLevel = consolidateByLowerLevel;
    }
}
